\version "2.24.0"
\language "deutsch"


\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 22))
  system-system-spacing = #'((basic-distance . 17))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Gazde mari, nu mai dormiţi"
  %subtitle = "pour ma femme (1977)"
  composer =  \markup \center-column { "Tiberiu Brediceanu" \small 
  "(1877-1968)" }
  %meter = "Allegro moderato"
  tagline=""
}

global = {
  %\key a \minor
  \key g \major
  \autoBeamOff
  %\time 3/4 
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Gaz -- de mari, nu mai dor -- miţi!
  Li -- li -- oa -- ră, tran -- da -- fir
  Că nu-i vre -- mea de dor -- mit.
  Li -- li -- oa -- ră, tran -- da -- fir.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Da-i vre -- mea de co -- lin -- dat
  Li -- li -- oa -- ră, tran -- da -- fir
  Și co -- co -- șii au cân -- tat.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Da-i vre -- mea de-m -- po -- do -- bit
  Li -- li -- oa -- ră, tran -- da -- fir
  Și Cră -- ciu -- nul a so -- sit.
}

menWords = \lyricmode {
}

sopMusic = \relative c'' {
  g4.^\mf c8 h4. g8 h4 a g4. h8\rest  
  d4.^\p cis8 d4 e d c h4. h8\rest
  d4.^\mf c8 h4. g8 h4 a g4. h8\rest
  \bar":|."
  d4.^\markup"Final" cis8 d4 e d4 d d4. h8\rest
  \bar "|."
}

altMusic = \relative c'' {
  g4. c8 h4. g8 g4 fis g4. h8\rest  
  h4. ais8 h4 c h a g4. h8\rest
  h4. a8 g4. g8 g4 fis g4. h8\rest
  h4. ais8 h4 c h a h4. h8\rest  
}

tenorMusic = \relative c' {
  g4. g8 g4. g8 d4 d g4. d8\rest
  g4. g8 g4 g g fis g4. d8\rest
  g4. g8 g4. g8 d4 d g4. d8\rest
  g4. g8 g4 g g fis g4. \fermata d8\rest
}


bassMusic = \relative c' {
  g4. g8 g4. g8 d4 d g4. d8\rest
  g4. g8 g4 c, d d g4. d8\rest
  g4. g8 g4. g8 d4 d g4. d8\rest
  g4. g8 g4 c, d d g,4. d'8\rest
}


myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
    >>
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      %\addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}